<?php
session_start();
$passwordProtect = true; // Şifre korumasını etkinleştirmek için true olarak ayarlayın

// Güvenli şifreleme için bcrypt kullanın
$correctPasswordHash = '$2a$12$wMwpjdVF1koCjqvlTKPlGeZ1aiJjnroho58ICR9FC18nWsUFQh3Lq'; // Buraya kendi bcrypt hash'inizi ekleyin

// Temel dizini ayarlayın (örneğin, bulunduğunuz dizin)
$base_dizin = __DIR__;

// Uzak sunucudan dosya çekme izni (isteğe bağlı)
$uzak_sunucu_izinli = true; // Uzak sunucudan dosya çekme özelliğini etkinleştirmek için true olarak ayarlayın

if ($passwordProtect) {
    if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
        if (isset($_POST['password'])) {
            // Şifreyi doğrulamak için password_verify kullanın
            if (password_verify($_POST['password'], $correctPasswordHash)) {
                $_SESSION['loggedin'] = true;
            } else {
                die("Incorrect password. Access denied.");
            }
        } else {
            echo '
            <!DOCTYPE html>
            <html lang="en">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Password Required</title>
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
                <script>
                    // Sayfa yüklendiğinde şifre inputuna odaklan
                    window.onload = function() {
                        document.getElementById("password").focus();
                    };
                </script>
            </head>
            <body>
                <div class="container mt-5">
                    <form method="POST" class="text-center">
                        <div class="mb-3">
                            <label for="password" class="form-label">Enter Password</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </body>
            </html>
            ';
            exit();
        }
    }
}

// Geçerli dizin
$currentDir = isset($_GET['dir']) ? $_GET['dir'] : '.';
$currentDir = realpath($currentDir);
if (!$currentDir) {
    $currentDir = realpath(__DIR__);
}

// Yeni klasör oluşturma
if (isset($_POST['create_folder'])) {
    $folderName = $_POST['folder_name'];
    $newFolderPath = $currentDir . '/' . $folderName;
    if (!is_dir($newFolderPath)) {
        mkdir($newFolderPath);
        echo "<script>alert('Klasör başarıyla oluşturuldu.');</script>";
    } else {
        echo "<script>alert('Bu isimde bir klasör zaten var.');</script>";
    }
}

// Yeni dosya oluşturma
if (isset($_POST['create_file'])) {
    $fileName = $_POST['file_name'];
    $fileContent = $_POST['file_content'];
    $newFilePath = $currentDir . '/' . $fileName;
    file_put_contents($newFilePath, $fileContent);
    echo "<script>alert('Dosya başarıyla oluşturuldu.');</script>";
}

// Dosya yükleme
if (isset($_FILES['upload_file'])) {
    $uploadedFile = $_FILES['upload_file'];
    $destination = $currentDir . '/' . basename($uploadedFile['name']);
    if (move_uploaded_file($uploadedFile['tmp_name'], $destination)) {
        echo "<script>alert('Dosya başarıyla yüklendi.');</script>";
    } else {
        echo "<script>alert('Dosya yüklenirken bir hata oluştu.');</script>";
    }
}

// Dosya veya klasörü yeniden adlandırma
if (isset($_POST['rename_item'])) {
    $oldName = $_POST['old_name'];
    $newName = $_POST['new_name'];
    if (rename($currentDir . '/' . $oldName, $currentDir . '/' . $newName)) {
        echo "<script>alert('Ad başarıyla değiştirildi.');</script>";
    } else {
        echo "<script>alert('Ad değiştirilirken bir hata oluştu.');</script>";
    }
}

// Dosya veya klasörü silme
if (isset($_POST['delete_item'])) {
    $itemName = $_POST['item_name'];
    $itemPath = $currentDir . '/' . $itemName;
    if (is_dir($itemPath)) {
        rmdir($itemPath);
        echo "<script>alert('Klasör başarıyla silindi.');</script>";
    } elseif (is_file($itemPath)) {
        unlink($itemPath);
        echo "<script>alert('Dosya başarıyla silindi.');</script>";
    } else {
        echo "<script>alert('Silinecek öğe bulunamadı.');</script>";
    }
}

// Zip dosyasını açma
if (isset($_POST['unzip_file'])) {
    $zipFile = $_POST['zip_file'];
    $zip = new ZipArchive;
    if ($zip->open($currentDir . '/' . $zipFile) === TRUE) {
        $zip->extractTo($currentDir);
        $zip->close();
        echo "<script>alert('ZIP dosyası başarıyla açıldı.');</script>";
    } else {
        echo "<script>alert('ZIP dosyası açılırken bir hata oluştu.');</script>";
    }
}

// Uzaktan dosya çekme
if (isset($_POST['fetch_remote_file'])) {
    $remoteUrl = $_POST['remote_url'];
    $fileName = basename($remoteUrl);
    $localPath = $currentDir . '/' . $fileName;
    
    if (file_put_contents($localPath, file_get_contents($remoteUrl))) {
        echo "<script>alert('Dosya başarıyla indirildi.');</script>";
    } else {
        echo "<script>alert('Dosya indirilirken bir hata oluştu.');</script>";
    }
}

// Dosya düzenleme
if (isset($_POST['edit_file'])) {
    $fileName = $_POST['file_name'];
    $fileContent = $_POST['file_content'];
    $filePath = $currentDir . '/' . $fileName;
    if (file_put_contents($filePath, $fileContent) !== false) {
        echo "<script>alert('Dosya başarıyla düzenlendi.');</script>";
    } else {
        echo "<script>alert('Dosya düzenlenirken bir hata oluştu.');</script>";
    }
}

// Geçerli dizindeki dosyaları ve klasörleri listeleme
$items = scandir($currentDir);

// Klasörleri ve dosyaları ayrı ayrı ayırarak sıralama
$directories = [];
$files = [];
foreach ($items as $item) {
    if ($item === '.' || ($item === '..' && realpath($currentDir) === realpath(__DIR__))) continue;

    if (is_dir($currentDir . '/' . $item)) {
        $directories[] = $item;
    } else {
        $files[] = $item;
    }
}
sort($directories);
sort($files);

// Dosya boyutunu okunabilir formata çevirme fonksiyonu
function formatFileSize($bytes) {
    if ($bytes >= 1073741824) {
        return number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        return number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        return number_format($bytes / 1024, 2) . ' KB';
    } elseif ($bytes > 1) {
        return $bytes . ' bytes';
    } elseif ($bytes == 1) {
        return '1 byte';
    } else {
        return '0 bytes';
    }
}

// Dizin yolunu parçalama ve tıklanabilir hale getirme
function generateBreadcrumbs($path) {
    $parts = explode(DIRECTORY_SEPARATOR, trim($path, DIRECTORY_SEPARATOR));
    $breadcrumbs = [];
    $cumulativePath = '';

    foreach ($parts as $part) {
        if ($cumulativePath === '') {
            $cumulativePath .= DIRECTORY_SEPARATOR . $part;
        } else {
            $cumulativePath .= DIRECTORY_SEPARATOR . $part;
        }

        $breadcrumbs[] = '<a href="?dir=' . urlencode($cumulativePath) . '">' . htmlspecialchars($part) . '</a>';
    }

    return implode(' / ', $breadcrumbs);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>PHP File Manager</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<style>
    .modal-card-body textarea {
        width: 100%;
        height: 300px;
    }
</style>
</head>
<body>
<section class="section">
<div class="container">
<h1 class="title">PHP File Manager</h1>

<nav class="breadcrumb" aria-label="breadcrumbs">
<ul>
<li><a href="?dir=<?php echo urlencode(realpath(__DIR__)); ?>">Home</a></li>
<?php echo generateBreadcrumbs($currentDir); ?>
</ul>
</nav>

<div class="box">
<h2 class="subtitle">Geçerli Dizin: <?php echo htmlspecialchars($currentDir); ?></h2>

<div class="columns">
    <div class="column">
        <form method="post" class="box">
            <h3 class="subtitle">Yeni Klasör Oluştur</h3>
            <div class="field has-addons">
                <div class="control">
                    <input type="text" name="folder_name" class="input" placeholder="Klasör Adı" required>
                </div>
                <div class="control">
                    <button type="submit" name="create_folder" class="button is-primary">Oluştur</button>
                </div>
            </div>
        </form>
    </div>
    <div class="column">
        <form method="post" enctype="multipart/form-data" class="box">
            <h3 class="subtitle">Dosya Yükle</h3>
            <div class="field has-addons">
                <div class="control">
                    <input type="file" name="upload_file" class="input" required>
                </div>
                <div class="control">
                    <button type="submit" class="button is-primary">Yükle</button>
                </div>
            </div>
        </form>
    </div>
    <div class="column">
        <form method="post" class="box">
            <h3 class="subtitle">Uzaktan Dosya Çek</h3>
            <div class="field has-addons">
                <div class="control">
                    <input type="url" name="remote_url" class="input" placeholder="https://example.com/file.zip" required>
                </div>
                <div class="control">
                    <button type="submit" name="fetch_remote_file" class="button is-primary">Çek</button>
                </div>
            </div>
        </form>
    </div>
</div>

<table class="table is-fullwidth is-striped">
<thead>
<tr>
<th>İsim</th>
<th>Boyut</th>
<th>Yazma İzni</th>
<th>Son Değişiklik</th>
<th>İşlemler</th>
</tr>
</thead>
<tbody>
<!-- Klasörleri Listele -->
<?php foreach ($directories as $directory): ?>
<tr>
<td><i class="fas fa-folder"></i> <a href="?dir=<?php echo urlencode($currentDir . '/' . $directory); ?>"><?php echo htmlspecialchars($directory); ?></a></td>
<td>-</td>
<td><?php echo is_writable($currentDir . '/' . $directory) ? 'Evet' : 'Hayır'; ?></td>
<td><?php echo date("Y-m-d H:i:s", filemtime($currentDir . '/' . $directory)); ?></td>
<td>
<button class="button is-small is-info" onclick="renameItem('<?php echo htmlspecialchars($directory); ?>')">Ad Değiştir</button>
<button class="button is-small is-danger" onclick="deleteItem('<?php echo htmlspecialchars($directory); ?>')">Sil</button>
</td>
</tr>
<?php endforeach; ?>

<!-- Dosyaları Listele -->
<?php foreach ($files as $file): ?>
<tr>
<td><i class="fas fa-file"></i> <?php echo htmlspecialchars($file); ?></td>
<td><?php echo formatFileSize(filesize($currentDir . '/' . $file)); ?></td>
<td><?php echo is_writable($currentDir . '/' . $file) ? 'Evet' : 'Hayır'; ?></td>
<td><?php echo date("Y-m-d H:i:s", filemtime($currentDir . '/' . $file)); ?></td>
<td>
<button class="button is-small is-info" onclick="editFile('<?php echo htmlspecialchars($file); ?>')">Düzenle</button>
<button class="button is-small is-warning" onclick="renameItem('<?php echo htmlspecialchars($file); ?>')">Ad Değiştir</button>
<button class="button is-small is-danger" onclick="deleteItem('<?php echo htmlspecialchars($file); ?>')">Sil</button>
<?php if (pathinfo($file, PATHINFO_EXTENSION) == 'zip'): ?>
<form method="post" style="display:inline;">
<input type="hidden" name="zip_file" value="<?php echo htmlspecialchars($file); ?>">
<button type="submit" name="unzip_file" class="button is-small is-link"><i class="fas fa-file-archive"></i> Unzip</button>
</form>
<?php endif; ?>
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

</div>
</div>
</section>

<!-- Modals -->
<div id="editModal" class="modal">
  <div class="modal-background"></div>
  <div class="modal-card">
    <header class="modal-card-head">
      <p class="modal-card-title">Dosya Düzenle</p>
      <button class="delete" aria-label="close" onclick="closeModal('editModal')"></button>
    </header>
    <section class="modal-card-body">
      <form id="editForm" method="post">
        <input type="hidden" id="editFileName" name="file_name">
        <textarea id="editFileContent" name="file_content"></textarea>
    </section>
    <footer class="modal-card-foot">
      <button type="submit" name="edit_file" class="button is-success">Kaydet</button>
      <button class="button" onclick="closeModal('editModal')">İptal</button>
      </form>
    </footer>
  </div>
</div>

<div id="renameModal" class="modal">
  <div class="modal-background"></div>
  <div class="modal-card">
    <header class="modal-card-head">
      <p class="modal-card-title">Yeniden Adlandır</p>
      <button class="delete" aria-label="close" onclick="closeModal('renameModal')"></button>
    </header>
    <section class="modal-card-body">
      <form id="renameForm" method="post">
        <input type="hidden" id="oldItemName" name="old_name">
        <div class="field">
          <label class="label">Yeni Ad:</label>
          <div class="control">
            <input class="input" type="text" id="newItemName" name="new_name" required>
          </div>
        </div>
    </section>
    <footer class="modal-card-foot">
      <button type="submit" name="rename_item" class="button is-success">Kaydet</button>
      <button class="button" onclick="closeModal('renameModal')">İptal</button>
      </form>
    </footer>
  </div>
</div>

<script>
function editFile(fileName) {
    fetch('?dir=<?php echo urlencode($currentDir); ?>&file=' + encodeURIComponent(fileName))
        .then(response => response.text())
        .then(content => {
            document.getElementById('editFileName').value = fileName;
            document.getElementById('editFileContent').value = content;
            openModal('editModal');
        });
}

function renameItem(itemName) {
    document.getElementById('oldItemName').value = itemName;
    document.getElementById('newItemName').value = itemName;
    openModal('renameModal');
}

function deleteItem(itemName) {
    if (confirm('Bu öğeyi silmek istediğinizden emin misiniz?')) {
        let form = document.createElement('form');
        form.method = 'post';
        form.innerHTML = `
            <input type="hidden" name="item_name" value="${itemName}">
            <input type="hidden" name="delete_item" value="1">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

function openModal(modalId) {
    document.getElementById(modalId).classList.add('is-active');
}

function closeModal(modalId) {
    document.getElementById(modalId).classList.remove('is-active');
}

// Tüm modallara close event listener ekle
document.querySelectorAll('.modal-background, .modal .delete, .modal .cancel').forEach(elem => {
    elem.addEventListener('click', (e) => {
        e.target.closest('.modal').classList.remove('is-active');
    });
});
</script>
</body>
</html>