<?php
/**
 * The header for our theme
 *
 * @subpackage Luxury Furniture Store
 * @since 1.0
 * @version 0.1
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
} else {
    do_action( 'wp_body_open' );
}?>

<a class="screen-reader-text skip-link" href="#skip-content"><?php esc_html_e( 'Skip to content', 'luxury-furniture-store' ); ?></a>

<div id="header">
	<div class="main-header">
		<div class="announcement-bar">
			<div class="h-offer">
				<div class="h-offtxt">
					<li><i class="fa fa-bolt"></i><?php echo esc_html(get_theme_mod('luzuk_luxury_furniture_store_header_anouncementbar_text')); ?></li>
					<li><i class="fa fa-bolt"></i><?php echo esc_html(get_theme_mod('luzuk_luxury_furniture_store_header_anouncementbar_text')); ?></li>
					<li><i class="fa fa-bolt"></i><?php echo esc_html(get_theme_mod('luzuk_luxury_furniture_store_header_anouncementbar_text')); ?></li>
					<li><i class="fa fa-bolt"></i><?php echo esc_html(get_theme_mod('luzuk_luxury_furniture_store_header_anouncementbar_text')); ?></li>
				</div>
			</div>
		</div>
		<div class="top-head">
			<div class="container">
				<div class="row m-0">
					<div class="col-xxl-3 col-xl-3 col-lg-3 col-md-3 col-sm-12 col-12 pd-0">
						<div class="logo ">
							<?php if ( has_custom_logo() ) : ?>
								<?php the_custom_logo(); ?>
							<?php endif; ?>
							<?php if (get_theme_mod('luzuk_luxury_furniture_store_show_site_title',true)) {?>
								<?php $blog_info = get_bloginfo( 'name' ); ?>
								<?php if ( ! empty( $blog_info ) ) : ?>
									<?php if ( is_front_page() && is_home() ) : ?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
								<?php endif; ?>
							<?php }?>
							<?php if (get_theme_mod('luzuk_luxury_furniture_store_show_tagline',true)) {?>
								<?php $description = get_bloginfo( 'description', 'display' );
								if ( $description || is_customize_preview() ) : ?>
									<p class="site-description"><?php echo esc_html($description); ?></p>
								<?php endif; ?>
							<?php }?>
						</div>
					</div>
					<div class="col-xxl-6 col-xl-6 col-lg-5 col-md-7 col-sm-9 col-9">
						<?php if(class_exists('woocommerce')){ ?>
							<div class="search-box">
								<?php if(class_exists('woocommerce')){ ?>
									<?php get_search_form() ?>
								<?php }?> 
							</div>
						<?php }?>
					</div>
					<div class="col-xxl-3 col-xl-3 col-lg-4 col-md-2 col-sm-3 col-3 ">
						<div class=" acc">
							<div class="row mr-0">
								<div class="signinregister">
									<div class="signinregisterinnbx">
									<?php if ( class_exists( 'WooCommerce' ) ) { ?>
										<a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>">
											<p><i class="fas fa-user-circle"></i><div class="signinregistertxt"> <?php esc_html_e('Sign In/ Account','luxury-furniture-store'); ?> </div></p>
										</a>
									<?php } ?>
									</div>
								</div>
								<div class="cartbtn">
									<?php if(class_exists('woocommerce')){ ?>
										<div class="cart">
											<div class="count"><?php echo wp_kses_data( WC()->cart->get_cart_contents_count() );?></div>
											<a class="cart-contents" href="<?php if(function_exists('wc_get_cart_url')){ echo esc_url(wc_get_cart_url()); } ?>"><i class="far fa-shopping-cart"></i>
													<div class="c-txt"><?php _e( 'Cart', 'luxury-furniture-store' ); ?> </div>
											</a>
											<!-- <li class="cart_box">
												<span class="cart-value"> <?php echo wp_kses_data( WC()->cart->get_cart_contents_count() );?></span>
											</li> -->
										</div>
									<?php }?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
		</div>			
		<div class="m-head">
			<div class="row mr-0">
				<div class="col-lg-1 col-md-1 col-sm-2 col-2 pd-0">
					<div class="header-category-box ">								
						<button class="product-btn">
							<i class="fa fa-bars" aria-hidden="true"></i>
						</button>
						<div class="product-cat" style="display: none">
							<?php
								$args = array(
									'number'     => 0,
									'orderby'    => 'title',
									'order'      => 'ASC',
									'hide_empty' => false,
								);
								$product_categories = get_terms('product_cat', $args);
								if (!is_wp_error($product_categories)) {
									$count = count($product_categories);
									if ($count > 0) {
										foreach ($product_categories as $product_category) {
											$cat_id   = $product_category->term_id;
											$cat_link = get_category_link($cat_id);
											if ($product_category->category_parent == 0) { ?>
												<li class="drp_dwn_menu">
													<a href="<?php echo esc_url(get_term_link($product_category)); ?>">
														<?php echo esc_html($product_category->name); ?>
													</a>
												</li>
											<?php }
										}
									} else { ?>
										<p class="no-categories-found"><?php esc_html_e('No product categories found.', 'luxury-furniture-store'); ?></p>
									<?php }
								} else { ?>
									<p class="no-categories-found"><?php esc_html_e('Error retrieving product categories.', 'luxury-furniture-store'); ?></p>
								<?php }
							?>
						</div>
					</div>

				</div>
				<div class="col-lg-9 col-md-9 col-sm-5 col-5">
					<div class="header-inner section-inner">
						<div class="header-titles-wrapper">
							<button class="toggle nav-toggle mobile-nav-toggle" data-toggle-target=".menu-modal"  data-toggle-body-class="showing-menu-modal" aria-expanded="false" data-set-focus=".close-nav-toggle">
								<span class="toggle-inner">
									<span class="toggle-icon">
										<i class="fas fa-bars"></i>
									</span>
									<!-- <span class="toggle-text"><//?php _e( 'Menu', 'luxury-furniture-store' ); ?></span> -->
								</span>
							</button><!-- .nav-toggle -->
						</div><!-- .header-titles-wrapper -->

						<div class="header-navigation-wrapper">
							<?php
							if ( has_nav_menu( 'primary' ) || ! has_nav_menu( 'expanded' ) ) {
								?>
								<nav class="primary-menu-wrapper" aria-label="<?php echo esc_attr_x( 'Horizontal', 'menu', 'luxury-furniture-store' ); ?>">
									<ul class="primary-menu reset-list-style">
										<?php
										if ( has_nav_menu( 'primary' ) ) {

											wp_nav_menu(
												array(
													'container'  => '',
													'items_wrap' => '%3$s',
													'theme_location' => 'primary',
												)
											);

										} elseif ( ! has_nav_menu( 'expanded' ) ) {

											wp_list_pages(
												array(
													'match_menu_classes' => true,
													'show_sub_menu_icons' => true,
													'title_li' => false,
													'walker'   => new Luxury_Furniture_Store_Walker_Page(),
												)
											);

										}
										?>
									</ul>
								</nav><!-- .primary-menu-wrapper -->
							<?php } ?>
						</div><!-- .header-navigation-wrapper -->
					</div><!-- .header-inner -->
					<?php
						// Output the menu modal.
						get_template_part( '/inc/modal-menu' );
					?>
				</div>
				<div class="col-lg-2 col-md-2 col-sm-5 col-5 pd-0">
					<div class="headerbtn">
						<a href="<?php echo esc_html(get_theme_mod('luzuk_luxury_furniture_store_header_btnlink')); ?>">
							<?php _e( 'Contact Us', 'luxury-furniture-store' ); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php if(is_singular()) {?>
	<div id="inner-pages-header">
		<div class="header-overlay"></div>
	    <div class="header-content">
		    <div class="container"> 
		      	<h1><?php single_post_title(); ?></h1>
		      	<div class="innheader-border"></div>
		      	<div class="theme-breadcrumb mt-2">
					<?php luzuk_luxury_furniture_store_breadcrumb();?>
				</div>
		    </div>
		</div>
	</div>
<?php } ?>