<?php
/**
 * Luxury Furniture Store: Customizer
 *
 * @subpackage Luxury Furniture Store
 * @since 1.0
 */

use WPTRT\Customize\Section\Luzuk_Luxury_Furniture_Store_Button;

add_action( 'customize_register', function( $manager ) {

	$manager->register_section_type( Luzuk_Luxury_Furniture_Store_Button::class );

	$manager->add_section(
		new Luzuk_Luxury_Furniture_Store_Button( $manager, 'luzuk_luxury_furniture_store_pro', [
			'title' => __( 'Luxury Furniture Store Pro', 'luxury-furniture-store' ),
			'priority' => 0,
			'button_text' => __( 'Go Pro', 'luxury-furniture-store' ),
			'button_url'  => esc_url( 'https://www.luzuk.com/products/furniture-wp-theme/', 'luxury-furniture-store')
		] )
	);

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'luxury-furniture-store-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
		[ 'customize-controls' ],
		$version,
		true
	);

	wp_enqueue_style(
		'luxury-furniture-store-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
		[ 'customize-controls' ],
 		$version
	);

} );

function luzuk_luxury_furniture_store_customize_register( $wp_customize ) {

	$wp_customize->add_setting('luzuk_luxury_furniture_store_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_logo_size',array(
		'type' => 'range',
		'description' => __('Logo Size (0-100%)','luxury-furniture-store'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_logo_padding',array(
		'label' => __('Logo Margin','luxury-furniture-store'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','luxury-furniture-store'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','luxury-furniture-store'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','luxury-furniture-store'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
 	));
 	$wp_customize->add_control('luzuk_luxury_furniture_store_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','luxury-furniture-store'),
		'section' => 'title_tagline',
    ));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','luxury-furniture-store'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_site_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_site_title_color', array(
		'label' => 'Title Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','luxury-furniture-store'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_site_tagline_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_site_tagline_color', array(
		'label' => 'Tagline Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_panel( 'luzuk_luxury_furniture_store_panel_id', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Theme Settings', 'luxury-furniture-store' ),
		'description' => __( 'Description of what this panel does.', 'luxury-furniture-store' ),
	) );

	$wp_customize->add_section( 'luzuk_luxury_furniture_store_theme_options_section', array(
    	'title'      => __( 'General Settings', 'luxury-furniture-store' ),
		'priority'   => 30,
		'panel' => 'luzuk_luxury_furniture_store_panel_id'
	) );

	$wp_customize->add_setting('luzuk_luxury_furniture_store_theme_options',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_theme_options',array(
		'type' => 'select',
		'label' => __('Blog Page Sidebar Layout','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_theme_options_section',
		'choices' => array(
		   'Left Sidebar' => __('Left Sidebar','luxury-furniture-store'),
		   'Right Sidebar' => __('Right Sidebar','luxury-furniture-store'),
		   'One Column' => __('One Column','luxury-furniture-store'),
		   'Grid Layout' => __('Grid Layout','luxury-furniture-store')
		),
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_single_post_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_single_post_sidebar',array(
        'type' => 'select',
        'label' => __('Single Post Sidebar Layout','luxury-furniture-store'),
        'section' => 'luzuk_luxury_furniture_store_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','luxury-furniture-store'),
            'Right Sidebar' => __('Right Sidebar','luxury-furniture-store'),
            'One Column' => __('One Column','luxury-furniture-store')
        ),
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_page_sidebar',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','luxury-furniture-store'),
        'section' => 'luzuk_luxury_furniture_store_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','luxury-furniture-store'),
            'Right Sidebar' => __('Right Sidebar','luxury-furniture-store'),
            'One Column' => __('One Column','luxury-furniture-store')
        ),
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_archive_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_archive_page_sidebar',array(
        'type' => 'select',
        'label' => __('Archive & Search Page Sidebar Layout','luxury-furniture-store'),
        'section' => 'luzuk_luxury_furniture_store_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','luxury-furniture-store'),
            'Right Sidebar' => __('Right Sidebar','luxury-furniture-store'),
            'One Column' => __('One Column','luxury-furniture-store'),
            'Grid Layout' => __('Grid Layout','luxury-furniture-store')
        ),
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_boxfull_width', array(
		'default'           => '',
		'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_choices'
	));
	
	$wp_customize->add_control( 'luzuk_luxury_furniture_store_boxfull_width', array(
		'label'    => __( 'Section Width', 'luxury-furniture-store' ),
		'section'  => 'luzuk_luxury_furniture_store_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'container'  => __('Box Width', 'luxury-furniture-store'),
			'container-fluid' => __('Full Width', 'luxury-furniture-store'),
			'none' => __('None', 'luxury-furniture-store')
		),
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_dropdown_anim', array(
		'default'           => 'None',
		'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_choices'
	));
	$wp_customize->add_control( 'luzuk_luxury_furniture_store_dropdown_anim', array(
		'label'    => __( 'Menu Dropdown Animations', 'luxury-furniture-store' ),
		'section'  => 'luzuk_luxury_furniture_store_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp'  => __('bounceInUp', 'luxury-furniture-store'),
			'fadeInUp' => __('fadeInUp', 'luxury-furniture-store'),
			'zoomIn'    => __('zoomIn', 'luxury-furniture-store'),
			'None'    => __('None', 'luxury-furniture-store')
		),
	));
 
	//Header
	$wp_customize->add_section( 'luzuk_luxury_furniture_store_header' , array(
    	'title'    => __( 'Header Settings', 'luxury-furniture-store' ),
		'priority' => null,
		'panel' => 'luzuk_luxury_furniture_store_panel_id'
	) );
	

	$wp_customize->add_setting('luzuk_luxury_furniture_store_header_anouncementbar_text',array(
		'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_header_anouncementbar_text',array(
	   	'type' => 'text',
	   	'label' => __('Announcement Bar Text','luxury-furniture-store'),
	   	'section' => 'luzuk_luxury_furniture_store_header',
	));
	
	$wp_customize->add_setting('luzuk_luxury_furniture_store_header_btnlink',array(
		'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_header_btnlink',array(
	   	'type' => 'text',
	   	'label' => __('Button Link','luxury-furniture-store'),
	   	'section' => 'luzuk_luxury_furniture_store_header',
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headerannouncementbaricontext_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headerannouncementbaricontext_col', array(
		'label' => 'Announcement Bar Icon & Text Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headerannouncementbaricontextbg_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headerannouncementbaricontextbg_col', array(
		'label' => 'Announcement Bar BG Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_searchicon_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_searchicon_col', array(
		'label' => 'Search bar Icon Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_searchiconbg_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_searchiconbg_col', array(
		'label' => 'Search bar Icon BG Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headeraccicon_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headeraccicon_col', array(
		'label' => 'Accounts Icon Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));


	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headeracctext_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headeracctext_col', array(
		'label' => 'Accounts Text Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));


	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headercarticon_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headercarticon_col', array(
		'label' => 'Cart Icon Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headercartnum_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headercartnum_col', array(
		'label' => 'Cart Number Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headercartnumbg_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headercartnumbg_col', array(
		'label' => 'Cart Number BG Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_headercarttext_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_headercarttext_col', array(
		'label' => 'Cart Text Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_menulefticon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_menulefticon_color', array(
		'label' => 'Menu Left Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_menubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_menubg_color', array(
		'label' => 'Menu BG Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_menu_color', array(
		'label' => 'Menu Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_menuhover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_menuhover_color', array(
		'label' => 'Menu Hover Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));


	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_submenu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_submenu_color', array(
		'label' => 'Submenu Text Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_submenubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_submenubg_color', array(
		'label' => 'Submenu BG Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_header_btntexticon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_header_btntexticon_color', array(
		'label' => 'Button Text Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_header_btntexticonbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_header_btntexticonbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_header_btntexticonhover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_header_btntexticonhover_color', array(
		'label' => 'Button Text Hover Color',
		'section' => 'luzuk_luxury_furniture_store_header',
	)));


	//home page slider
	$wp_customize->add_section( 'luzuk_luxury_furniture_store_slider_section' , array(
    	'title'    => __( 'Slider Settings', 'luxury-furniture-store' ),
		'description'=> __('<b>Note :</b> Please Add Image in 750*700 Ratio.','luxury-furniture-store'),
		'priority' => null,
		'panel' => 'luzuk_luxury_furniture_store_panel_id'
	) );

	$wp_customize->add_setting('luzuk_luxury_furniture_store_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_slider_hide_show',array(
	   	'type' => 'checkbox',
	   	'label' => __('Show / Hide Slider','luxury-furniture-store'),
	   	'section' => 'luzuk_luxury_furniture_store_slider_section',
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_slider_effect', array(
		'default'           => '',
		'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_choices'
	));
	$wp_customize->add_control( 'luzuk_luxury_furniture_store_slider_effect', array(
		'label'    => __( 'Onload Transactions Effects', 'luxury-furniture-store' ),
		'section'  => 'luzuk_luxury_furniture_store_slider_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft'  => __('bounceInLeft', 'luxury-furniture-store'),
			'bounceInRight' => __('bounceInRight', 'luxury-furniture-store'),
			'bounceInUp'    => __('bounceInUp', 'luxury-furniture-store'),
			'bounceInDown'    => __('bounceInDown', 'luxury-furniture-store'),
			'zoomIn'  => __('zoomIn', 'luxury-furniture-store'),
			'zoomOut' => __('zoomOut', 'luxury-furniture-store'),
			'fadeInDown'    => __('fadeInDown', 'luxury-furniture-store'),
			'fadeInUp'    => __('fadeInUp', 'luxury-furniture-store'),
			'fadeInLeft'  => __('fadeInLeft', 'luxury-furniture-store'),
			'fadeInRight' => __('fadeInRight', 'luxury-furniture-store'),
			'flip-up'    => __('flip-up', 'luxury-furniture-store'),
			'none'    => __('none', 'luxury-furniture-store')
		),
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'luzuk_luxury_furniture_store_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'luzuk_luxury_furniture_store_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'luzuk_luxury_furniture_store_slider' . $count, array(
			'label' => __('Select Slider Image Page', 'luxury-furniture-store' ),
			'section' => 'luzuk_luxury_furniture_store_slider_section',
			'type' => 'dropdown-pages'
		));
	}

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_slider_arrowicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_slider_arrowicon_color', array(
		'label' => 'Arrow Icon Color',
		'section' => 'luzuk_luxury_furniture_store_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_slider_arrowbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_slider_arrowbg_color', array(
		'label' => 'Arrow BG Color',
		'section' => 'luzuk_luxury_furniture_store_slider_section',
	)));


	// categories Section
	$wp_customize->add_section('luzuk_luxury_furniture_store_categories_section',array(
		'title'	=> __('Categories Settings','luxury-furniture-store'),
		'description'=> __('<b>Note :</b> This section will appear below the Slider.','luxury-furniture-store'),
		'panel' => 'luzuk_luxury_furniture_store_panel_id',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_productcategory_heading',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_productcategory_heading',array(
	   	'type' => 'text',
	   	'label' => __('Heading','luxury-furniture-store'),
	   	'section' => 'luzuk_luxury_furniture_store_categories_section',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_cat_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_cat_font_size',array(
		'type' => 'number',
		'label' => __('Font Size','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_categories_section',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_cat_img_height',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_cat_img_height',array(
		'type' => 'number',
		'description' => __('Image Height','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_categories_section',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_cat_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_cat_title_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_categories_section',
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_categoriesheading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_categoriesheading_color', array(
		'label' => 'Heading Color',
		'section' => 'luzuk_luxury_furniture_store_categories_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_categoriestitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_categoriestitle_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_luxury_furniture_store_categories_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_categoriestitlebg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_categoriestitlebg_color', array(
		'label' => 'Title BG Color',
		'section' => 'luzuk_luxury_furniture_store_categories_section',
	)));


	// newarrivalproduct Section
	$wp_customize->add_section('luzuk_luxury_furniture_store_newarrivalproduct_section',array(
		'title'	=> __('New Arrival Products Settings','luxury-furniture-store'),
		'description'=> __('<b>Note :</b> This section will appear below the Slider.','luxury-furniture-store'),
		'panel' => 'luzuk_luxury_furniture_store_panel_id',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_newarrivalproducts_heading',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_newarrivalproducts_heading',array(
	   	'type' => 'text',
	   	'label' => __('Heading','luxury-furniture-store'),
	   	'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_newarrivalproducts_heading_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_newarrivalproducts_heading_font_size',array(
		'type' => 'number',
		'label' => __('Font Size','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_newarrivalproducts_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_newarrivalproducts_font_size',array(
		'type' => 'number',
		'label' => __('Product Title Font Size','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_newarrivalproducts_price_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_newarrivalproducts_price_font_size',array(
		'type' => 'number',
		'label' => __('Product Price Font Size','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductheading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductheading_color', array(
		'label' => 'Heading Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductseealltxt_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductseealltxt_color', array(
		'label' => 'See All Button Text Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductseeallbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductseeallbg_color', array(
		'label' => 'See All Button BG Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductseeallbrd_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductseeallbrd_color', array(
		'label' => 'See All Button Border Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproducttitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproducttitle_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductprice_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductprice_color', array(
		'label' => 'Price Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductacctocartbtntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductacctocartbtntext_color', array(
		'label' => 'Add To Cart Button Text Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductacctocartbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductacctocartbtnbg_color', array(
		'label' => 'Add To Cart Button BG Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_newarrivalproductacctocartbtnborder_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_newarrivalproductacctocartbtnborder_color', array(
		'label' => 'Add To Cart Button Border Color',
		'section' => 'luzuk_luxury_furniture_store_newarrivalproduct_section',
	)));




	//Footer
    $wp_customize->add_section( 'luzuk_luxury_furniture_store_footer', array(
    	'title'  => __( 'Footer Settings', 'luxury-furniture-store' ),
		'priority' => null,
		'panel' => 'luzuk_luxury_furniture_store_panel_id'
	) );

	$wp_customize->add_setting('luzuk_luxury_furniture_store_show_back_totop',array(
       'default' => true,
       'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_checkbox'
    ));
    $wp_customize->add_control('luzuk_luxury_furniture_store_show_back_totop',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Back to Top','luxury-furniture-store'),
       'section' => 'luzuk_luxury_furniture_store_footer'
    ));

    $wp_customize->add_setting('luzuk_luxury_furniture_store_footer_copy',array(
		'default' => 'Luxury Furniture Store WordPress Theme By Luzuk',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('luzuk_luxury_furniture_store_footer_copy',array(
		'label'	=> __('Copyright Text','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_footer',
		'setting' => 'luzuk_luxury_furniture_store_footer_copy',
		'type' => 'text'
	));

	$wp_customize->add_setting('luzuk_luxury_furniture_store_footer_copy_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_luxury_furniture_store_sanitize_float'
	));
	$wp_customize->add_control('luzuk_luxury_furniture_store_footer_copy_font_size',array(
		'type' => 'number',
		'label' => __('Font Size','luxury-furniture-store'),
		'section' => 'luzuk_luxury_furniture_store_footer',
	));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footertitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footertitle_color', array(
		'label' => 'Widgets Title Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footermenu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footermenu_color', array(
		'label' => 'Widgets menus Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footerbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footerbg_color', array(
		'label' => 'BG Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footercopyright_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footercopyright_color', array(
		'label' => 'Copyright Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footercopyrightbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footercopyrightbg_color', array(
		'label' => 'Copyright BG Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footerscrolltotoptext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footerscrolltotoptext_color', array(
		'label' => 'Scroll To Top Text Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footerscrolltotopbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footerscrolltotopbg_color', array(
		'label' => 'Scroll To Top BG Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footerscrolltotoptexthover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footerscrolltotoptexthover_color', array(
		'label' => 'Scroll To Top Text Hover Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));

	$wp_customize->add_setting( 'luzuk_luxury_furniture_store_footerscrolltotophover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_luxury_furniture_store_footerscrolltotophover_color', array(
		'label' => 'Scroll To Top Hover Color',
		'section' => 'luzuk_luxury_furniture_store_footer',
	)));




	

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'luzuk_luxury_furniture_store_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'luzuk_luxury_furniture_store_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'luzuk_luxury_furniture_store_customize_register' );

function luzuk_luxury_furniture_store_customize_partial_blogname() {
	bloginfo( 'name' );
}

function luzuk_luxury_furniture_store_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if (class_exists('WP_Customize_Control')) {

   	class Luzuk_Luxury_Furniture_Store_Fontawesome_Icon_Chooser extends WP_Customize_Control {

      	public $type = 'icon';

      	public function render_content() { ?>
	     	<label>
	            <span class="customize-control-title">
	               <?php echo esc_html($this->label); ?>
	            </span>

	            <?php if ($this->description) { ?>
	                <span class="description customize-control-description">
	                   <?php echo wp_kses_post($this->description); ?>
	                </span>
	            <?php } ?>

	            <div class="luxury-furniture-store-selected-icon">
	                <i class="fa <?php echo esc_attr($this->value()); ?>"></i>
	                <span><i class="fa fa-angle-down"></i></span>
	            </div>

	            <ul class="luxury-furniture-store-icon-list clearfix">
	                <?php
	                $luzuk_luxury_furniture_store_font_awesome_icon_array = luzuk_luxury_furniture_store_font_awesome_icon_array();
	                foreach ($luzuk_luxury_furniture_store_font_awesome_icon_array as $luzuk_luxury_furniture_store_font_awesome_icon) {
	                   $icon_class = $this->value() == $luzuk_luxury_furniture_store_font_awesome_icon ? 'icon-active' : '';
	                   echo '<li class=' . esc_attr($icon_class) . '><i class="' . esc_attr($luzuk_luxury_furniture_store_font_awesome_icon) . '"></i></li>';
	                }
	                ?>
	            </ul>
	            <input type="hidden" value="<?php $this->value(); ?>" <?php $this->link(); ?> />
	        </label>
	        <?php
      	}
  	}
}
function luzuk_luxury_furniture_store_customizer_script() {
   wp_enqueue_style( 'font-awesome-1', esc_url(get_template_directory_uri()).'/assets/css/fontawesome-all.css');
}
add_action( 'customize_controls_enqueue_scripts', 'luzuk_luxury_furniture_store_customizer_script' );