<?php
session_start();

// Ayarlar
const PASSWORD_PROTECTED = false;
const HASHED_PASSWORD = '$2y$10$12uoT0mQpXrMpk8GC/LDe.irEtNbhsc5BSeruFwjBh3MGG8gRMaB.';
const BASE_DIR = __DIR__;
const ALLOW_REMOTE = true;

// Kimlik Dorulama
function checkAuth() {
    if (!PASSWORD_PROTECTED) return true;
    if (isset($_SESSION['logged_in']) && $_SESSION['logged_in']) return true;
    
    if (isset($_POST['pass'])) {
        if (password_verify($_POST['pass'], HASHED_PASSWORD)) {
            $_SESSION['logged_in'] = true;
            return true;
        }
        return false;
    }
    showLoginForm();
    exit;
}

function showLoginForm() {
    echo <<<HTML
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Giri</title>
        <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    </head>
    <body class="bg-gray-100 flex items-center justify-center h-screen">
        <form method="POST" class="bg-white p-6 rounded shadow-md">
            <h2 class="text-xl mb-4">ifre Gir</h2>
            <input type="password" name="pass" class="w-full p-2 border rounded mb-4" placeholder="ifre" required autofocus>
            <button type="submit" class="w-full bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Giri Yap</button>
        </form>
    </body>
    </html>
    HTML;
}

// Dosya Yneticisi levleri
checkAuth();
$dir = isset($_GET['path']) ? realpath($_GET['path']) : BASE_DIR;
if (!$dir || strpos($dir, BASE_DIR) !== 0) $dir = BASE_DIR;

function handleActions($dir) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['new_folder'])) {
            $path = $dir . '/' . $_POST['folder'];
            !is_dir($path) && mkdir($path) ? alert('Klasr oluturuldu.') : alert('Klasr zaten var.');
        }
        if (isset($_FILES['file_upload'])) {
            $file = $dir . '/' . basename($_FILES['file_upload']['name']);
            move_uploaded_file($_FILES['file_upload']['tmp_name'], $file) ? alert('Dosya yklendi.') : alert('Ykleme hatas.');
        }
        if (isset($_POST['remote_url']) && ALLOW_REMOTE) {
            $url = $_POST['remote_url'];
            $file = $dir . '/' . basename($url);
            file_put_contents($file, file_get_contents($url)) ? alert('ndirildi.') : alert('ndirme hatas.');
        }
        if (isset($_POST['delete'])) {
            $path = $dir . '/' . $_POST['item'];
            is_dir($path) ? rmdir($path) : unlink($path);
            alert('Silindi.');
        }
        if (isset($_POST['rename'])) {
            $old = $dir . '/' . $_POST['old'];
            $new = $dir . '/' . $_POST['new'];
            rename($old, $new) ? alert('Yeniden adlandrld.') : alert('Hata.');
        }
        if (isset($_POST['save_file'])) {
            $file = $dir . '/' . $_POST['filename'];
            file_put_contents($file, $_POST['content']) !== false ? alert('Kaydedildi.') : alert('Hata.');
        }
        if (isset($_POST['unzip'])) {
            $zip = new ZipArchive;
            $file = $dir . '/' . $_POST['zipname'];
            $zip->open($file) === TRUE && $zip->extractTo($dir) && $zip->close() ? alert('karld.') : alert('Hata.');
        }
    }
}

function alert($msg) {
    echo "<script>alert('$msg');</script>";
}

handleActions($dir);

// Dosya ve Klasr Listesi
$contents = array_diff(scandir($dir), ['.', '..']);
$folders = array_filter($contents, fn($item) => is_dir("$dir/$item"));
$files = array_diff($contents, $folders);
sort($folders);
sort($files);

function sizeFormat($bytes) {
    $units = ['B', 'KB', 'MB', 'GB'];
    $i = floor(log($bytes, 1024));
    return $bytes ? round($bytes / pow(1024, $i), 2) . ' ' . $units[$i] : '0 B';
}

function breadcrumbs($path) {
    $parts = array_filter(explode('/', str_replace(BASE_DIR, '', $path)));
    $crumbs = ['<a href="?path=' . BASE_DIR . '" class="text-blue-500 hover:underline">Ana Sayfa</a>'];
    $current = BASE_DIR;
    foreach ($parts as $part) {
        $current .= '/' . $part;
        $crumbs[] = '<a href="?path=' . urlencode($current) . '" class="text-blue-500 hover:underline">' . htmlspecialchars($part) . '</a>';
    }
    return implode(' > ', $crumbs);
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dosya Yneticisi</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50 p-6">
    <div class="max-w-5xl mx-auto">
        <h1 class="text-3xl font-bold mb-4">Dosya Yneticisi</h1>
        <div class="mb-4 text-gray-600"><?php echo breadcrumbs($dir); ?></div>
        <div class="bg-white p-4 rounded shadow-md">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <form method="POST" class="space-y-2">
                    <h3 class="text-lg font-semibold">Yeni Klasr</h3>
                    <input type="text" name="folder" class="w-full p-2 border rounded" placeholder="Klasr Ad" required>
                    <button type="submit" name="new_folder" class="w-full bg-green-500 text-white p-2 rounded hover:bg-green-600">Olutur</button>
                </form>
                <form method="POST" enctype="multipart/form-data" class="space-y-2">
                    <h3 class="text-lg font-semibold">Dosya Ykle</h3>
                    <input type="file" name="file_upload" class="w-full p-2 border rounded" required>
                    <button type="submit" class="w-full bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Ykle</button>
                </form>
                <?php if (ALLOW_REMOTE): ?>
                <form method="POST" class="space-y-2">
                    <h3 class="text-lg font-semibold">Uzak Dosya</h3>
                    <input type="url" name="remote_url" class="w-full p-2 border rounded" placeholder="URL" required>
                    <button type="submit" class="w-full bg-purple-500 text-white p-2 rounded hover:bg-purple-600">ndir</button>
                </form>
                <?php endif; ?>
            </div>
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="p-2">Ad</th>
                        <th class="p-2">Boyut</th>
                        <th class="p-2">Yazlabilir</th>
                        <th class="p-2">Son Deiiklik</th>
                        <th class="p-2">lemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($folders as $folder): ?>
                    <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-folder mr-1"></i><a href="?path=<?php echo urlencode("$dir/$folder"); ?>" class="text-blue-500 hover:underline"><?php echo htmlspecialchars($folder); ?></a></td>
                        <td class="p-2">-</td>
                        <td class="p-2"><?php echo is_writable("$dir/$folder") ? 'Evet' : 'Hayr'; ?></td>
                        <td class="p-2"><?php echo date('Y-m-d H:i', filemtime("$dir/$folder")); ?></td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="rename('<?php echo htmlspecialchars($folder); ?>')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Ad Deitir</button>
                            <button onclick="del('<?php echo htmlspecialchars($folder); ?>')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Sil</button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php foreach ($files as $file): ?>
                    <tr class="hover:bg-gray-100">
                        <td class="p-2"><i class="fas fa-file mr-1"></i><?php echo htmlspecialchars($file); ?></td>
                        <td class="p-2"><?php echo sizeFormat(filesize("$dir/$file")); ?></td>
                        <td class="p-2"><?php echo is_writable("$dir/$file") ? 'Evet' : 'Hayr'; ?></td>
                        <td class="p-2"><?php echo date('Y-m-d H:i', filemtime("$dir/$file")); ?></td>
                        <td class="p-2 flex space-x-2">
                            <button onclick="edit('<?php echo htmlspecialchars($file); ?>')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Dzenle</button>
                            <button onclick="rename('<?php echo htmlspecialchars($file); ?>')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Ad Deitir</button>
                            <button onclick="del('<?php echo htmlspecialchars($file); ?>')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Sil</button>
                            <?php if (pathinfo($file, PATHINFO_EXTENSION) === 'zip'): ?>
                            <form method="POST" class="inline">
                                <input type="hidden" name="zipname" value="<?php echo htmlspecialchars($file); ?>">
                                <button type="submit" name="unzip" class="bg-purple-500 text-white px-2 py-1 rounded hover:bg-purple-600">kar</button>
                            </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Dzenleme Modal -->
    <div id="edit-modal" class="fixed inset-0 bg-gray-800 bg-opacity-50 hidden flex items-center justify-center">
        <div class="bg-white p-6 rounded shadow-lg w-full max-w-2xl">
            <h2 class="text-xl mb-4">Dosya Dzenle</h2>
            <form method="POST">
                <input type="hidden" id="edit-filename" name="filename">
                <textarea id="edit-content" name="content" class="w-full h-64 p-2 border rounded mb-4"></textarea>
                <div class="flex justify-end space-x-2">
                    <button type="submit" name="save_file" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">Kaydet</button>
                    <button type="button" onclick="closeModal()" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">ptal</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Yeniden Adlandrma Modal -->
    <div id="rename-modal" class="fixed inset-0 bg-gray-800 bg-opacity-50 hidden flex items-center justify-center">
        <div class="bg-white p-6 rounded shadow-lg w-full max-w-md">
            <h2 class="text-xl mb-4">Yeniden Adlandr</h2>
            <form method="POST">
                <input type="hidden" id="rename-old" name="old">
                <input type="text" id="rename-new" name="new" class="w-full p-2 border rounded mb-4" required>
                <div class="flex justify-end space-x-2">
                    <button type="submit" name="rename" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">Kaydet</button>
                    <button type="button" onclick="closeModal()" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">ptal</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    function edit(file) {
        fetch(`?path=<?php echo urlencode($dir); ?>&file=${encodeURIComponent(file)}`)
            .then(res => res.text())
            .then(content => {
                document.getElementById('edit-filename').value = file;
                document.getElementById('edit-content').value = content;
                document.getElementById('edit-modal').classList.remove('hidden');
            });
    }
    function rename(item) {
        document.getElementById('rename-old').value = item;
        document.getElementById('rename-new').value = item;
        document.getElementById('rename-modal').classList.remove('hidden');
    }
    function del(item) {
        if (confirm('Bu eyi silmek istediinizden emin misiniz?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `<input type="hidden" name="item" value="${item}"><input type="hidden" name="delete" value="1">`;
            document.body.appendChild(form);
            form.submit();
        }
    }
    function closeModal() {
        document.getElementById('edit-modal').classList.add('hidden');
        document.getElementById('rename-modal').classList.add('hidden');
    }
    </script>
</body>
</html>