<?php
session_start();

// Configuration
$passwordProtect = true;
$correctPasswordHash = '$2a$12$wMwpjdVF1koCjqvlTKPlGeZ1aiJjnroho58ICR9FC18nWsUFQh3Lq'; // Replace with your bcrypt hash
$remoteFetchAllowed = true;
$uploadDir = './'; // Upload directory (ensure it exists and is writable)
$allowedExtensions = ['php', 'pdf', 'jpg', 'jpeg', 'png', 'gif', 'zip']; // Allowed file extensions

// Ensure upload directory exists
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// Check if user is authenticated
if ($passwordProtect && !isset($_SESSION['authenticated'])) {
    if (isset($_POST['password'])) {
        if (password_verify($_POST['password'], $correctPasswordHash)) {
            $_SESSION['authenticated'] = true;
        } else {
            $error = "Incorrect password!";
        }
    } else {
        // Display login form
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>File Manager - Login</title>
            <style>
                body { font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; }
                .error { color: red; }
                .form-group { margin-bottom: 15px; }
                input[type="password"] { width: 100%; padding: 8px; }
                button { padding: 10px 20px; background: #007BFF; color: white; border: none; cursor: pointer; }
                button:hover { background: #0056b3; }
            </style>
        </head>
        <body>
            <h2>File Manager Login</h2>
            <?php if (isset($error)) { echo "<p class='error'>$error</p>"; } ?>
            <form method="POST">
                <div class="form-group">
                    <label for="password">Password:</label>
                    <input type="password" id="password" name="password" required>
                </div>
                <button type="submit">Login</button>
            </form>
        </body>
        </html>
        <?php
        exit;
    }
}

// Handle file upload
if (isset($_FILES['file'])) {
    $file = $_FILES['file'];
    $fileName = basename($file['name']);
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    $targetFile = $uploadDir . $fileName;

    if (in_array($fileExt, $allowedExtensions)) {
        if (move_uploaded_file($file['tmp_name'], $targetFile)) {
            $message = "File uploaded successfully!";
        } else {
            $error = "Failed to upload file!";
        }
    } else {
        $error = "File extension not allowed!";
    }
}

// Handle file deletion
if (isset($_GET['delete'])) {
    $fileToDelete = $uploadDir . basename($_GET['delete']);
    if (file_exists($fileToDelete) && unlink($fileToDelete)) {
        $message = "File deleted successfully!";
    } else {
        $error = "Failed to delete file!";
    }
}

// Handle file editing
if (isset($_POST['edit_file']) && isset($_POST['file_content'])) {
    $fileToEdit = $uploadDir . basename($_POST['edit_file']);
    if (file_exists($fileToEdit) && is_writable($fileToEdit)) {
        file_put_contents($fileToEdit, $_POST['file_content']);
        $message = "File updated successfully!";
    } else {
        $error = "Failed to update file!";
    }
}

// Get list of files
$files = array_diff(scandir($uploadDir), ['.', '..']);

// Display file manager
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>File Manager</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px; }
        .message { color: green; }
        .error { color: red; }
        .file-list { margin-top: 20px; }
        .file-list a { margin-right: 10px; }
        .form-group { margin-bottom: 15px; }
        input[type="file"], textarea { width: 100%; padding: 8px; }
        button { padding: 10px 20px; background: #007BFF; color: white; border: none; cursor: pointer; }
        button:hover { background: #0056b3; }
    </style>
</head>
<body>
    <h2>File Manager</h2>
    <?php
    if (isset($message)) { echo "<p class='message'>$message</p>"; }
    if (isset($error)) { echo "<p class='error'>$error</p>"; }
    ?>

    <!-- File Upload Form -->
    <h3>Upload File</h3>
    <form method="POST" enctype="multipart/form-data">
        <div class="form-group">
            <input type="file" name="file" required>
        </div>
        <button type="submit">Upload</button>
    </form>

    <!-- File List -->
    <h3>Files</h3>
    <div class="file-list">
        <?php if (empty($files)): ?>
            <p>No files found.</p>
        <?php else: ?>
            <ul>
                <?php foreach ($files as $file): ?>
                    <li>
                        <a href="<?php echo $uploadDir . $file; ?>" download><?php echo $file; ?></a>
                        <a href="?delete=<?php echo urlencode($file); ?>" onclick="return confirm('Are you sure you want to delete this file?');">Delete</a>
                        <a href="?edit=<?php echo urlencode($file); ?>">Edit</a>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>

    <!-- File Edit Form -->
    <?php if (isset($_GET['edit'])): ?>
        <?php
        $fileToEdit = $uploadDir . basename($_GET['edit']);
        $fileContent = file_exists($fileToEdit) ? file_get_contents($fileToEdit) : '';
        ?>
        <h3>Edit File: <?php echo basename($_GET['edit']); ?></h3>
        <form method="POST">
            <div class="form-group">
                <textarea name="file_content" rows="10" required><?php echo htmlspecialchars($fileContent); ?></textarea>
                <input type="hidden" name="edit_file" value="<?php echo basename($_GET['edit']); ?>">
            </div>
            <button type="submit">Save Changes</button>
        </form>
    <?php endif; ?>

    <!-- Logout -->
    <form method="POST" action="?logout">
        <button type="submit">Logout</button>
    </form>

    <?php
    // Handle logout
    if (isset($_GET['logout'])) {
        session_destroy();
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }
    ?>
</body>
</html>